/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.libs.com.fasterxml.jackson.databind.deser.std;

import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.BeanDescription;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.DeserializationConfig;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.JavaType;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.JsonDeserializer;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.JsonMappingException;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.KeyDeserializer;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.MapperFeature;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.deser.KeyDeserializers;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.util.ClassUtil;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.util.EnumResolver;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class StdKeyDeserializers
implements KeyDeserializers,
Serializable {
    private static final long serialVersionUID = 1L;

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver) {
        return new StdKeyDeserializer.EnumKD(enumResolver, null);
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver, AnnotatedMethod factory) {
        return new StdKeyDeserializer.EnumKD(enumResolver, factory);
    }

    public static KeyDeserializer constructDelegatingKeyDeserializer(DeserializationConfig config2, JavaType type, JsonDeserializer<?> deser) {
        return new StdKeyDeserializer.DelegatingKD(type.getRawClass(), deser);
    }

    public static KeyDeserializer findStringBasedKeyDeserializer(DeserializationConfig config2, JavaType type) {
        BeanDescription beanDesc = config2.introspect(type);
        Constructor<?> ctor = beanDesc.findSingleArgConstructor(String.class);
        if (ctor != null) {
            if (config2.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(ctor, config2.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            return new StdKeyDeserializer.StringCtorKeyDeserializer(ctor);
        }
        Method m = beanDesc.findFactoryMethod(String.class);
        if (m != null) {
            if (config2.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(m, config2.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            return new StdKeyDeserializer.StringFactoryKeyDeserializer(m);
        }
        return null;
    }

    @Override
    public KeyDeserializer findKeyDeserializer(JavaType type, DeserializationConfig config2, BeanDescription beanDesc) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        if (raw.isPrimitive()) {
            raw = ClassUtil.wrapperType(raw);
        }
        return StdKeyDeserializer.forType(raw);
    }
}

